/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.arrows.paint;

import com.itayfeder.nock_enough_arrows.NockEnoughArrowsConfig;
import com.itayfeder.nock_enough_arrows.arrows.paint.PaintArrowItem;
import com.itayfeder.nock_enough_arrows.init.EntityTypeInit;
import com.itayfeder.nock_enough_arrows.init.ItemInit;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PaintArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(PaintArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_TRIGGERED = SynchedEntityData.m_135353_(PaintArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PaintArrow(EntityType<? extends PaintArrow> p_37411_, Level p_37412_) {
        super(p_37411_, p_37412_);
    }

    public PaintArrow(Level p_37419_, LivingEntity p_37420_, DyeColor color) {
        super((EntityType)EntityTypeInit.PAINT_ARROW.get(), p_37420_, p_37419_);
        this.setColor(color);
    }

    public PaintArrow(Level p_37414_, double p_37415_, double p_37416_, double p_37417_, DyeColor color) {
        super((EntityType)EntityTypeInit.PAINT_ARROW.get(), p_37415_, p_37416_, p_37417_, p_37414_);
        this.setColor(color);
    }

    public PaintArrow(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends PaintArrow>)((EntityType)EntityTypeInit.PAINT_ARROW.get()), world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && !this.f_36703_) {
            Vector3f vec = new Vector3f(this.getColor().m_41068_());
            this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(vec, 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLOR, (Object)0);
        this.f_19804_.m_135372_(DATA_TRIGGERED, (Object)false);
    }

    protected ItemStack m_7941_() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PAINT_ARROW.get());
        PaintArrowItem.setColor(stack, this.getColor());
        return stack;
    }

    public void m_7380_(CompoundTag p_29923_) {
        super.m_7380_(p_29923_);
        p_29923_.m_128344_("Color", (byte)this.getColor().m_41060_());
    }

    public void m_7378_(CompoundTag p_29915_) {
        super.m_7378_(p_29915_);
        if (p_29915_.m_128425_("Color", 99)) {
            this.setColor(DyeColor.m_41053_((int)p_29915_.m_128451_("Color")));
        }
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLOR)));
    }

    public void setColor(DyeColor p_30398_) {
        if (p_30398_ == null) {
            this.f_19804_.m_135381_(DATA_COLOR, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_.m_41060_());
        }
    }

    public boolean isTriggered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TRIGGERED);
    }

    public void setTriggered(boolean bool) {
        this.f_19804_.m_135381_(DATA_TRIGGERED, (Object)bool);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
        if (!this.isTriggered()) {
            this.DyeBlock(p_36755_);
        }
    }

    protected void m_5790_(EntityHitResult p_36757_) {
        Shulker shulker;
        Sheep sheep;
        super.m_5790_(p_36757_);
        Entity hit = p_36757_.m_82443_();
        DyeColor color = this.getColor();
        if (hit instanceof Sheep && (sheep = (Sheep)hit).m_6084_() && !sheep.m_29875_() && sheep.m_29874_() != color) {
            sheep.f_19853_.m_6269_(null, (Entity)sheep, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!this.f_19853_.f_46443_) {
                sheep.m_29855_(color);
            }
        }
        if (hit instanceof Shulker && (shulker = (Shulker)hit).m_6084_() && shulker.m_33467_() != color) {
            shulker.f_19853_.m_6269_(null, (Entity)shulker, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!this.f_19853_.f_46443_) {
                shulker.m_149777_(color);
            }
        }
    }

    public void DyeBlock(BlockHitResult p_36755_) {
        DyeColor color = this.getColor();
        BlockPos pos = p_36755_.m_82425_();
        BlockState state = this.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        boolean inTags = false;
        for (String tagName : (List)NockEnoughArrowsConfig.COMMON.unpaintableBlockTags.get()) {
            ResourceLocation location = new ResourceLocation(tagName.split(":")[0], tagName.split(":")[1]);
            if (ForgeRegistries.BLOCKS.tags().getTag(ForgeRegistries.BLOCKS.tags().createTagKey(location)).contains((Object)block)) {
                inTags = true;
            }
            if (!inTags) continue;
            break;
        }
        if (!inTags) {
            ResourceLocation registryBlock = ForgeRegistries.BLOCKS.getKey((Object)block);
            String cotainedDye = "";
            for (ResourceLocation dyecolor : DyeColor.values()) {
                if (!registryBlock.m_135815_().contains(dyecolor.m_41065_())) continue;
                cotainedDye = dyecolor.m_41065_();
                break;
            }
            if (!cotainedDye.equals("") && !cotainedDye.equals(color.m_41065_())) {
                ResourceLocation newLocation = new ResourceLocation(registryBlock.m_135827_(), registryBlock.m_135815_().replace(cotainedDye, color.m_41065_()));
                Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(newLocation);
                if (!newBlock.m_49966_().m_60795_()) {
                    BlockState newState = PaintArrow.replaceStates(newBlock.m_49966_(), state);
                    CompoundTag nbt = this.f_19853_.m_7702_(pos) != null ? this.f_19853_.m_7702_(pos).serializeNBT() : null;
                    this.f_19853_.m_7731_(pos, newState, 2);
                    if (nbt != null) {
                        this.f_19853_.m_7702_(pos).deserializeNBT(nbt);
                    }
                    this.setTriggered(true);
                    this.setColor(DyeColor.WHITE);
                } else {
                    ResourceLocation tintedLocation = new ResourceLocation(registryBlock.m_135827_().equals("tinted") ? "minecraft" : "tinted", registryBlock.m_135815_().replace(cotainedDye, color.m_41065_()));
                    Block tintedBlock = (Block)ForgeRegistries.BLOCKS.getValue(tintedLocation);
                    if (!tintedBlock.m_49966_().m_60795_()) {
                        BlockState newState = PaintArrow.replaceStates(tintedBlock.m_49966_(), state);
                        CompoundTag nbt = this.f_19853_.m_7702_(pos) != null ? this.f_19853_.m_7702_(pos).serializeNBT() : null;
                        this.f_19853_.m_7731_(pos, newState, 2);
                        if (nbt != null) {
                            this.f_19853_.m_7702_(pos).deserializeNBT(nbt);
                        }
                        this.setTriggered(true);
                        this.setColor(DyeColor.WHITE);
                    }
                }
            }
        }
    }

    private static BlockState replaceStates(BlockState newBlock, BlockState originalBlock) {
        BlockState block = newBlock;
        for (Property property : originalBlock.m_61147_()) {
            if (!newBlock.m_61138_(property) || originalBlock.m_61143_(property) == null) continue;
            block = (BlockState)block.m_61124_(property, originalBlock.m_61143_(property));
        }
        return block;
    }
}

